/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.Constants;

class SideBandProgressMonitor
extends BatchingProgressMonitor {
    private final OutputStream out;
    private boolean write;

    SideBandProgressMonitor(OutputStream os) {
        this.out = os;
        this.write = true;
    }

    @Override
    protected void onUpdate(String taskName, int workCurr, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr, duration);
        s2.append("   \r");
        this.send(s2);
    }

    @Override
    protected void onEndTask(String taskName, int workCurr, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr, duration);
        s2.append(", done\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int workCurr, Duration duration) {
        s2.append(taskName);
        s2.append(": ");
        s2.append(workCurr);
        this.appendDuration(s2, duration);
    }

    @Override
    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt, duration);
        s2.append("   \r");
        this.send(s2);
    }

    @Override
    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt, duration);
        s2.append("\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        s2.append(taskName);
        s2.append(": ");
        if (pcnt < 100) {
            s2.append(' ');
        }
        if (pcnt < 10) {
            s2.append(' ');
        }
        s2.append(pcnt);
        s2.append("% (");
        s2.append(cmp);
        s2.append('/');
        s2.append(totalWork);
        s2.append(')');
        this.appendDuration(s2, duration);
    }

    private void send(StringBuilder s2) {
        if (this.write) {
            try {
                this.out.write(Constants.encode(s2.toString()));
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

